;*****************************************************************************************************************
;Source File Name:
;		aim95.jss
;Author's Name:
;		Ben Key 
;Description:
;		JFW Script file for aim95.exe, the instalation program for the AOL instant messenger.
;Included Header Files:
;		hjconst.jsh			default HJ constants 
;		hjglobal.jsh		default HJ global variables
;		aim95.jsm			aim95.exe specific messages
;		aim95.jsh			Header file to store globals and constants to be used in aim95.jss
;*****************************************************************************************************************
;																Member Functions
;Void Function ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
;Void Function SayFocusedWindow ()
;Int Function DidControlChange ()
;Script SayTargetDirectoryAndFreeSpaceInformation ()
;Script  ScriptFileName()
;*****************************************************************************************************************
;
;
;*****************************************************************************************************************
;						                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/22/1999		Ben Key					Project started
;06/23/1999		Ben Key					aim95.jsh added to the project
;																SayFocusWindow completed
;																DidControlChange added
;																Script SayTargetDirectoryAndFreeSpaceInformation () added
;																Script  ScriptFileName() added
;																Improved documentation in Aim95.jsd
;*****************************************************************************************************************

include "hjconst.jsh"			; default HJ constants 
include "hjglobal.jsh"		; default HJ global variables
Include "AIM.jsh"
Include "AIM.jsm"


;*****************************************************************************************************************
;Function:	
;		Void ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
;Author's Name:
;		Ben Key
;Description:
;		This function is based upon the screen scensitive help for known classes function found
;		in default.jss.  It is used to customize the messages that are spoken when screen 
;		sensitive help is called for certain controls.  Messages for the following controls have been 
;		customized:
;			1. buttons		Now say "This is the {button name} button" rather than "this is a button."
;			2. Read Only edit
;Parameters:
;		int nSubTypeCode		The window subtype code of the window that currently has focus
;Globals
;	Used:
;	Modified:
;Return Value:		Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/22/1999		Ben Key					Project started
;*****************************************************************************************************************
Void Function ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
var  int TheTypeCode, string RealName, String strTest
let theTypeCode = nSubTypeCode
if (TheTypeCode == WT_BUTTON) then ;#1
	Say (kcmsg001, ot_help) ;"This is the"
	Say (GetWindowName (GetCurrentWindow ()), ot_help)
	Say (kcmsg001a, ot_help) ;"button"
	Say (kcmsg002, ot_help) ;"Use enter to activate it"
	Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_COMBOBOX) then ;#2
  Say (kcmsg004, ot_help) ;"This is a Combo box"
  Say (kcmsg005a, ot_help) ;"type in a value or use the arrow keys to move between the items"
  Say (kcmsg005b, ot_help); " use the arrow keys to move between the items"
  Say (kcmsg005c, ot_help); "use alt plus up arrow or Escape to close the list box"
  Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
  Return
EndIf
if (TheTypeCode == WT_EDIT) then ;#3
  Say (kcmsg007, ot_help) ;"This is an edit field in which you can type information"
  Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  If (IsInfoCenter () == 0) then
    Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
  EndIf
  Return
EndIf
if (TheTypeCode == WT_LISTBOX) then ;#4
  if (IsSelectScriptDlg()) then
    Say (kcmsg009, ot_help) ;"This is an execute item list box"
    Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
    Say (kcmsg145, ot_help) ;"Use the space bar to toggle the selected item"
    Say (kcmsg146, ot_help) ;"Use the enter key to close this dialog"
  elif (IsSelectItemDlg()) then
    Say (kcmsg147, ot_help) ;"this is a select item list box"
    Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
    Say (kcmsg148, ot_help) ;"Use enter to choose the item and exit the dialog"
    Say (kcmsg149, ot_help) ;"Use escape to cancel the dialog"
  else
    Say (kcmsg016, ot_help) ;"This is a list box"
    Let strTest = GetWindowName (GetRealWindow (GetFocus ()))
    Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
    Say (kcmsg018, ot_help) ;"Use Enter to select it"
    Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
  endif
  Return
EndIf
if (TheTypeCode == WT_SCROLLBAR) ||
(TheTypeCode ==WT_LEFTRIGHTSCROLLBAR)
 then ;#5
	Say (kcmsg019, ot_help) ;"This is a scroll bar"
	Say (kcmsg020, ot_help) ;"Use the right arrow down arrow or page down keys to increase the value"
	Say (kcmsg021, ot_help) ;"Use the left arrow up arrow or page up keys to decrease the value"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
elif  (TheTypeCode ==WT_UPDOWNSCROLLBAR) Then
	Say (kcmsg142, ot_help) ;"This is an Up Down scroll bar"
	Say (kcmsg143, ot_help) ;"Use the right arrow down arrow or page down keys to decrease the value"
	Say (kcmsg144, ot_help) ;"Use the left arrow up arrow or page up keys to increase the value"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
EndIf
if (TheTypeCode == WT_STATIC) then ;#6
	Say (kcmsg022, ot_help) ;"This is static text for information only"
	Say (kcmsg023, ot_help) ;"Use the reading keys to read the text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_TOOLBAR) then ;#7
	Say (kcmsg024, ot_help) ;"this is a tool bar"
	Say (kcmsg025, ot_help) ;"it contains various controls and graphics"
	Say (kcmsg026, ot_help) ;"it is generally accessed with the mouse by point and click"
	Say (kcmsg027, ot_help) ;"most tool bar items can also be found within menus"
	Return
endif
if (TheTypeCode == WT_STATUSBAR) then ;#8
	Say (kcmsg028, ot_help) ;"This is an application status bar"
	Say (kcmsg029, ot_help) ;"It provides a variety of information depending on the focus"
	Say (kcmsg030, ot_help) ;"by default jaws will read this with insert plus page down"
	Return
endif
if (TheTypeCode == WT_HEADERBAR) then ;#9
	Say (kcmsg031, ot_help) ;"This is a header bar"
	Say (kcmsg032, ot_help) ;"it contains titles for various columns below the header bar"
	Say (kcmsg033, ot_help) ;"clicking on a particular title"
	Say (kcmsg034, ot_help) ;"will generally sort the list based on the information in that column"
	Return
endif
if (TheTypeCode == WT_SPINBOX) then ;#12
	Say (kcmsg035, ot_help) ;"This is a spin box"
	Say (kcmsg036, ot_help) ;"you can edit this control manually or"
	Say (kcmsg037, ot_help) ;"arrow up or down arrow to increase or decrease its value"
	Return
endif
;WT_MENU = 13,
if (TheTypeCode == WT_MENU) then
	Say (kcmsg038, ot_help) ;"This is a menu"
	Say (kcmsg039, ot_help) ;"Use the arrow keys to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg013, ot_help) ;"use the hotkey as a shortcut key or"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_DESKTOP = 14,
if (TheTypeCode == WT_DESKTOP) then
	Say (kcmsg041, ot_help) ;"This is the desktop"
	Say (kcmsg042, ot_help) ;"This is the area underlying all application windows"
	Return
EndIf
;WT_ICONTITLE = 16,
if (TheTypeCode == WT_ICONTITLE) then
	Say (kcmsg043, ot_help) ;"This is an Icon Title resulting from a minimized group or application"
	If (IsJAWSCursor ()) then
		Say (kcmsg044, ot_help) ;"Press the left mouse button to activate"
		Return
	EndIf
	If (IsPCCursor ()) then
		Say (kcmsg045, ot_help) ;"Press enter to activate"
		Return
	EndIf
EndIf
;WT_MDICLIENT = 17,
if (TheTypeCode == WT_MDICLIENT) then
	Say (kcmsg046, ot_help) ;"This is an multiple document interface client window"
	Say (kcmsg047, ot_help) ;"This is the space underlying documents in an m d i environment"
	Return
EndIf
;WT_DIALOG = 18,
if (TheTypeCode == WT_DIALOG) then
	Say (kcmsg048, ot_help) ;"This is a dialog box"
	Say (kcmsg049, ot_help) ;"Use the tab keys to move between the fields"
	Return
EndIf
;WT_RADIOBUTTON = 19,
if (TheTypeCode == WT_RADIOBUTTON) then
	Say (kcmsg050, ot_help) ;"This is one of a group of radio buttons"
	Say (kcmsg051, ot_help) ;"only one can be checked at a time"
	Say (kcmsg052, ot_help) ;"Use the up and down arrow keys to move the check mark"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_CHECKBOX = 20,
if (TheTypeCode == WT_CHECKBOX) then
	Say (kcmsg053, ot_help) ;"This is a check box"
	Say (kcmsg054, ot_help) ;"Use the space bar to toggle the check mark on and off"
	Say (kcmsg055, ot_help) ;"Read current line or word to read it"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_GROUPBOX = 21,
if (TheTypeCode == WT_GROUPBOX) then
	Say (kcmsg056, ot_help) ;"This is a groupbox"
	If (GetVerbosity () == 0) then
		Say (kcmsg057, ot_help) ;"It is used to group items that are related"
		Say (kcmsg058, ot_help) ;"such as radio buttons"
	EndIf
	Say (kcmsg059, ot_help) ;"use the pc cursor to move between the controls"
	Return
EndIf
;WT_SDM = 23,
if (TheTypeCode == WT_SDM) then
	Say (kcmsg048, ot_help) ;"This is a dialog box"
	Say (kcmsg060, ot_help) ;"use tab and shift tab to move between the controls"
	Say (kcmsg061, ot_help) ;"select ok to accept the changes or cancel to ignore the changes"
	Return
EndIf
;WT_GENERALPICTURE= 25,
if (TheTypeCode == WT_GENERALPICTURE) then
	Say (kcmsg062, ot_help) ;"This is a General picture"
	Say (kcmsg063, ot_help) ;" functions or designs specific to the application"
	Return
EndIf
;WT_HOTKEY = 28,
if (TheTypeCode == WT_HOTKEY) then
	Say (kcmsg064, ot_help) ;"This is a hot key or short cut key edit control"
	Say (kcmsg065, ot_help) ;"be careful or you may define a short cut key by pressing any letter key"
	Say (kcmsg066, ot_help) ;"or most combinations of letter key and alt control or shift"
	Say (kcmsg067, ot_help) ;"use the tab key to move to the next control"
	Return
EndIf
;WT_TABCONTROL=29,
if (TheTypeCode == WT_TABCONTROL) then
	Say (kcmsg068, ot_help) ;"This is a tab control found in multi page dialog boxes"
	Say (kcmsg069, ot_help) ;"use the arrow keys to move between the tabs"
	Say (kcmsg070, ot_help) ;"use the tab key to move between the controls in the dialog box"
	Return
EndIf
;WT_LISTVIEW=30,
if (TheTypeCode == WT_LISTVIEW) then
	let RealName = GetWindowName (GetRealWindow (GetCurrentWindow()))
;wn187="Desktop"
	if RealName == wnDesktop then
		Say (kcmsg071, ot_help) ;"This is the desktop list view"
		Say (kcmsg072, ot_help) ;"It contains shortcut icons"
		Say (kcmsg073, ot_help) ;"use the arrow keys to move from item to item"
		Say (kcmsg074, ot_help) ;"or press the first letter of the desired item"
		Say (kcmsg075, ot_help) ;"Press enter or double click to select"
		Say (kcmsg076, ot_help) ;"Press tab to move to the start button or shift + tab to move to the task bar"
		Say (kcmsg077, ot_help) ;"if the desktop items are not being read correctly"
		Say (kcmsg078, ot_help) ;"you may need to minimize all applications"
		Say (kcmsg079, ot_help) ;"this can be accomplished with insert plus f6"
		Return
	else
		Say (kcmsg080, ot_help) ;"This is a list view"
		Say (kcmsg081, ot_help) ;"use the arrow keys to read through the items"
		Say (kcmsg082, ot_help) ;"or press the first letter to jump to a desired item"
		Say (kcmsg083, ot_help) ;"items can be contained in one or more columns"
		Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
		Say (kcmsg085, ot_help) ;"hold down the shift key as you arrow up or down"
		Say (kcmsg086, ot_help) ;"to select a non contiguous group of items"
		Say (kcmsg087, ot_help) ;"hold down the control key as you arrow up and down"
		Say (kcmsg088, ot_help) ;"and use control plus space bar"
		Say (kcmsg089, ot_help) ;" to select or unselect items"
		Say (kcmsg090, ot_help) ;"to here the items that have been selected"
		Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
		Say (kcmsg092, ot_help) ;"we recommend that you put files in a single column with all details"
		Say (kcmsg093, ot_help) ;"by selecting details from the view menu"
		Return
	EndIf
EndIf
;WT_TREEVIEW=31,
if (TheTypeCode == WT_TREEVIEW) then
	Say (kcmsg094, ot_help) ;"Tree view level "
	SayInteger (GetTreeViewLevel ())
	Say (kcmsg095, ot_help) ;"use up or down arrow to read through the items"
	Say (kcmsg096, ot_help) ;"or press the first letter to jump through the list"
	Say (kcmsg097, ot_help) ;"use the right or left arrow keys to open or close an item or"
	Say (kcmsg098, ot_help) ;"use shift with the plus or minus key"
	Say (kcmsg099, ot_help) ;"to move to the prior level press backspace"
	Say (kcmsg100, ot_help) ;"to move to the root of the tree press home"
	Say (kcmsg101, ot_help) ;"to move to the last item on the tree press end"
	Return
EndIf
;WT_STARTBUTTON=32,
if (TheTypeCode == WT_STARTBUTTON) then
	Say (kcmsg102, ot_help) ;"This is the start button"
	Say (kcmsg103, ot_help) ;"Press Enter to open the start menu"
	Say (kcmsg104, ot_help) ;"items in the start menu are used to launch applications"
	Say (kcmsg105, ot_help) ;"or tab to move to the task bar"
	Say (kcmsg106, ot_help) ;"you can use control plus escape to activate this menu at any time"
	Return
EndIf
;WT_STARTMENU=33,
if (TheTypeCode == WT_STARTMENU) then
	Say (kcmsg107, ot_help) ;"This is the start menu"
	Say (kcmsg108, ot_help) ;"items in this menu are used to launch applications"
	Say (kcmsg109, ot_help) ;"Use up or down arrow to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_CONTEXTMENU=34,
if (TheTypeCode == WT_CONTEXTMENU) then
	Say (kcmsg110, ot_help) ;"This is the context menu"
	Say (kcmsg109, ot_help) ;"Use up or down arrow to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_task bar=35
if (TheTypeCode == WT_TASKBAR) then
	Say (kcmsg111, ot_help) ;"This is the task bar"
	Say (kcmsg112, ot_help) ;" it contains the currently running applications"
	Say (kcmsg069, ot_help) ;"use the arrow keys to move between the tabs"
	Say (kcmsg113, ot_help) ;" use enter to invoke the application"
	Say (kcmsg114, ot_help)	 ;"use alt plus enter to open the task bar properties dialog"
	Say (kcmsg115, ot_help) ;"use the tab key to move to the desktop"
	Return
EndIf
;WT_MULTISELECT_LISTBOX=37,
if (TheTypeCode == WT_MULTISELECT_LISTBOX) then
	Say (kcmsg116, ot_help) ;"This is a multiselect listbox"
	Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
	Say (kcmsg117, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (kcmsg086, ot_help) ;"to select a non contiguous group of items"
	Say (kcmsg087, ot_help) ;"hold down the control key as you arrow up and down"
	Say (kcmsg118, ot_help) ;"and use the space bar to select the item"
	Say (kcmsg090, ot_help) ;"to here the items that have been selected"
	Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
;WT_EXTENDEDSELECT_LISTBOX=38,
if (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX) then
	Say (kcmsg119, ot_help) ;"This is an extended select list box"
	Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
	Say (kcmsg117, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (kcmsg120, ot_help) ;"use shift + f8 to toggle the extended select option"
	Say (kcmsg121, ot_help) ;"When the extended select option is on"
	Say (kcmsg122, ot_help) ;"you can select multiple items with your space bar"
	Say (kcmsg090, ot_help) ;"to here the items that have been selected"
	Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
if (TheTypeCode == WT_LEFTRIGHTSLIDER) then ;#39
	Say (kcmsg123, ot_help) ;"This is a horizontal slider"
	Say (kcmsg124, ot_help) ;"the value of the control increases as you move to the right"
	Say (kcmsg125, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (kcmsg126, ot_help) ;"volume or pitch"
	Return
endif
if (TheTypeCode == WT_UPDOWNSLIDER) then ;#40
	Say (kcmsg127, ot_help) ;"This is a vertical slider"
	Say (kcmsg128, ot_help) ;"the value of the control increases as you move upward"
	Say (kcmsg125, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (kcmsg126, ot_help) ;"volume or pitch"
	Return
endif
;WT_EDITCOMBO = 41
if (TheTypeCode == WT_EDITCOMBO) then ;#41
	Say (kcmsg129, ot_help) ;"This is an edit Combo box"
	Say (kcmsg005, ot_help) ;"type in a value or use alt plus down arrow to open the list box"
	Say (kcmsg005b, ot_help); " use the arrow keys to move between the items"
	Say (kcmsg005c, ot_help); "use alt plus up arrow or Escape to close the list box"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Say (kcmsg150, ot_help) ;" previously selected items"
	Return
endif
;WT_PASSWORDEDIT=42,
if (TheTypeCode == WT_PASSWORDEDIT) then ;#42
	Say (kcmsg130, ot_help) ;"This is a password edit control"
	Say (kcmsg151, ot_help) ;" visually replaced by asteriks"
	Say (kcmsg131, ot_help) ;"Use the backspace to delete and start over"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
endif
if (TheTypeCode == WT_READONLYEDIT) then ;#43
	Let RealName = GetWindowName (GetRealWindow (GetFocus ()))	
	If (StringContains (RealName, wnLicense)) then
		Say (schLicense, ot_help)
		Say (schReadOnly1, ot_help)
		Say (schReadOnly2, ot_help)
		Return
	Else
		Say (schReadOnly1, ot_help)
		Say (schReadOnly2, ot_help)
;		Say (kcmsg132, ot_help) ;"This text is reed only"
;		Say (kcmsg133, ot_help) ;"you can navigate and read text with the jaws cursor"
;		Say (kcmsg134, ot_help) ;"but you cannot edit the text"
		Return
	EndIf
endif
if (theTypeCode == WT_COMMANDBAR) then ;#44
	Say (kcmsg136, ot_help);"This is a command bar"
	Say (kcmsg137, ot_help);"it consists of a row of buttons"
	Say (kcmsg138, ot_help) ;"you can arrow left or right to hear the different button names"
	Say (kcmsg139, ot_help) ;"and press enter to activate a button"
	Say (kcmsg140, ot_help) ;"press control plus tab to move to the next command bar"
	Say (kcmsg141, ot_help) ;"press escape to leave the command bar"
	return
endif
if (GlobalMenuMode == MENUBAR_ACTIVE) then
	Say (kcmsg010, ot_help) ;"This is the menu bar"
	Say (kcmsg011, ot_help) ;"you can arrow left and right to hear the different menu names"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg013, ot_help) ;"use the hotkey as a shortcut key or"
	Say (kcmsg014, ot_help) ;"press enter or down arrow to open a menu"
	Say (kcmsg015, ot_help) ;"press escape to exit the menu bar"
	return
endif
;if it gets this far it did not recognize the type code.
Say (kcmsg135, ot_help) ;"The Type Code is"
SayInteger (TheTypeCode)
ScreenSensitiveHelpForUnknownClasses (); catch everything not yet handled
EndFunction


Void Function ReadInstallationDialogs (string rWinTitle, handle rWin)
Var Handle hTarget, Handle tmpHandle
; Customize the speaking of the Software License Agreement window so that the static text 
; window that appear near the top and the bottom of the real window get spoken 
; automatically
If (StringContains (rWinTitle, wnLicense)) then
	; The first child window of the real window has a window class of #32770.  Both of the static 
	; windows are descendant windows of this window.
	;The first window of interest has a control ID of 7.  Use FindDescendantWindow to find its 
	; window handle and use SayWindow to read its contents.
	Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_LicenseStaticA)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	;The second window of interest has a control ID of 9.  Use FindDescendantWindow to find its 
	; window handle and use SayWindow to read its contents.
	Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_LicenseStaticB)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	; Say the current control and return
	SayWindowTypeAndText (GetCurrentWindow ())
	Return
; Customize the speaking of the AOL Instant Messenger (SM) Installation windows so that the 
; static text windows that form the bulk of the real window get spoken automatically.
ElIf (StringContains (rWinTitle, wnInstallA)) then
	; There are several windows that have a window title of "AOL Instant Messenger (SM) 
	; Installation."  Each of the windows have the same basic structure.  In each window the 
	; first child window of the real window has a window class of #32770.  All of of the static 
	; windows that need to be spoken automatically are descendant windows of this window.  
	; In order to distinguish between the windows, use FindString to search the window for an 
	; identifying string of text and handle the particular window accordingly.
	SaveCursor ()
	InvisibleCursor ()
	If (FindString (rWin, strWelcome, S_TOP, S_RESTRICTED)) then		; Welcome Screen
		RestoreCursor ()
		;The first window of interest has a control ID of 7.  Use FindDescendantWindow to find its 
		; window handle and use SayWindow to read its contents.
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_InstallStaticA)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		;The second window of interest has a control ID of 8.  Use FindDescendantWindow to find 
		; its window handle and use SayWindow to read its contents.
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_InstallStaticB)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		; Say the current control and return
		SayWindowTypeAndText (GetCurrentWindow ())
		Return
	ElIf (FindString (rWin, strSelectDirectory, S_TOP, S_RESTRICTED)) then	; Select a target directory screen
		RestoreCursor ()
		;The first window of interest has a control ID of 8.  Use FindDescendantWindow to find its 
		; window handle and use SayWindow to read its contents.
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_SelectDirStaticA)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		; The second window of interest has a control ID of 10.  It contains the default installation 
		; directory.  Say the message "The default target directory is" and then use 
		; FindDescendantWindow to find its window handle and use SayWindow to read its 
		; contents.
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_SelectDirStaticB)
		If (hTarget) then Delay (1) Say (msgDefaultDir, ot_message) Delay (1) SayWindow (hTarget, READ_EVERYTHING) EndIf
		; The next four windows show the current free disk space on the default destination drive 
		; and the free disk space after installation.  They have the following control ID's: 13, 12, 
		; 14, 11.  Use FindDescendantWindow to find each window handle and then use 
		; SayWindow to speak its contents.
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_FreeDiskSpaceA)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_FreeDiskSpaceB)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_FreeDiskSpaceC)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_FreeDiskSpaceD)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		; Say the current control and return
		SayWindowTypeAndText (GetCurrentWindow ())
		Return
	ElIf (FindString (rWin, strConnectionType, S_TOP, S_RESTRICTED)) then	; Select connection type screen
		RestoreCursor ()
		;	There is a single static window with a control ID of 9 within this dialog box that must be 
		; read.  Use FindDescendantWindow (...) to obtain the window handle and use 
		; SayWindow (...) to read it.  Then say the active control.
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_ConnectionType)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		SayWindowTypeAndText (GetCurrentWindow ())
		Return
	ElIf (FindString (rWin, strReady, S_TOP, S_RESTRICTED)) then	; Select a target directory screen
		RestoreCursor ()
		;The first window of interest has a control ID of 7.  Use FindDescendantWindow to find its 
		; window handle and use SayWindow to read its contents.
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_ReadyA)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		;The second window of interest has a control ID of 8.  Use FindDescendantWindow to find 
		; its window handle and use SayWindow to read its contents.
		Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_ReadyB)
		If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
		; Say the current control and return
		SayWindowTypeAndText (GetCurrentWindow ())
		Return
	EndIf
EndIf
EndFunction


;*****************************************************************************************************************
;Function:	
;		Void Function SayFocusedWindow ()
;Author's Name:
;		Ben Key
;Description:
;		This function is used to customize how JFW reads certain windows encountered during
;		the installation of AOL Instant Messenger.  The windows customized are as follows:
;		1.  The Software License Agreement window.
;		2.  The AOL Instant Messenger (SM) Installation windows
;				a. Several window in a row that have the same window title and window handle
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/22/1999		Ben Key
;	Project started
; 06/23/1999		Ben Key
;	Changed test to decide whether to speak the entire window or simply
;	speak the current control to include a test to determine if the control in
;	a dialog box had changed.  This was to solve the problem caused by the fact
;	that there are several real windows in a row that have the same window
;	handle and window title.
;	Included support for all windows not previously supported.
;*****************************************************************************************************************
Void Function SayFocusedWindow ()
Var Handle hTarget, String rWinTitle, Handle rWin, Handle tmpHandle, Handle prevFirstChild
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let prevFirstChild = FirstChild
Let FirstChild = GetFirstChild (rWin)
CopyToClipboard (GlobalPrevRealName)
; If moving from one dialog box to the next
If (FirstChild != prevFirstChild) then
	ReadInstallationDialogs (rWinTitle, rWin)
;	If switching from a different application
ElIf (StringContains (GlobalPrevRealName, wnLicense) == FALSE
	&& StringContains (GlobalPrevRealName, wnInstallA) == FALSE) then
	ReadInstallationDialogs (rWinTitle, rWin)
Else
	If (StringContains (rWinTitle, wnLicense) && GetCurrentControlID () == cID_LicenseEdit) then
		Say (msgLicenseEdit, ot_message)
	Else SayWindowTypeAndText (GlobalFocusWindow) EndIf
EndIf
EndFunction

;*****************************************************************************************************************
;Script:	
;		Script SayTargetDirectoryAndFreeSpaceInformation ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to say the target directory and free space information in the 
;		select a target directory screen of the AOL Instant messenger instalation program.  This
; 		is accomplished by finding the window handles of the various static windows that contain
;		the valid information using FindDescendantWindow (...) and saying the window contents
; 		by passing the found window handles to SayWindow (...)
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/23/1999		Ben Key
;	Script created
;*****************************************************************************************************************

Script SayTargetDirectoryAndFreeSpaceInformation ()
Var Handle hTarget, String rWinTitle, Handle rWin, Handle tmpHandle
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
SaveCursor ()
If (FindString (rWin, strSelectDirectory, S_TOP, S_RESTRICTED)) then
	RestoreCursor ()
	; The first window of interest has a control ID of 10.  It contains the default installation 
	; directory.  Say the message "The current target directory is" and then use 
	; FindDescendantWindow to find its window handle and use SayWindow to read its contents.
	Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_SelectDirStaticB)
	If (hTarget) then Delay (1) Say (msgCurrentDir, ot_message) Delay (1) SayWindow (hTarget, READ_EVERYTHING) EndIf
	; The next four windows show the current free disk space on the default destination drive 
	; and the free disk space after installation.  They have the following control ID's: 13, 12, 14, 
	; 11.  Use FindDescendantWindow to find each window handle and then use SayWindow to 
	; speak its contents.
	Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_FreeDiskSpaceA)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_FreeDiskSpaceB)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_FreeDiskSpaceC)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
	Let hTarget = FindDescendantWindow (GetFirstChild (GetRealWindow (GetFocus ())), cID_FreeDiskSpaceD)
	If (hTarget) then SayWindow (hTarget, READ_EVERYTHING) EndIf
Else Say (msgNotSelectDirScreen, ot_message) EndIf
EndScript


;*****************************************************************************************************************
;Script:	
;		Script  ScriptFileName()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to say the script and application name by calling the function
;  	ScriptAndAppNames with the string parameter AOL Instant messenger setup
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/23/1999		Ben Key
;	Script created
;*****************************************************************************************************************

Script  ScriptFileName()
ScriptAndAppNames(msgScriptFile) ;msgScriptFile = "AOL Instant messenger setup",
EndScript

Void Function HotKeyLoop ()
Var Handle rWin, Handle hFirstChild, Handle hTemp, Int nTypeCode, 
Int FoundHotKey, String strHelpPhrase, String strType
Let FoundHotKey = 0
Let strHelpPhrase = ""
Let rWin = GetRealWindow (GetFocus ())
Let hFirstChild = GetFirstChild (rWin)
Let hTemp = GetFirstChild (hFirstChild)
SaveCursor ()
InvisibleCursor ()
;JAWSCursor ()
While (hTemp)
	let nTypeCode = GetWindowTypeCode (hTemp)
	If ((nTypeCode == WT_BUTTON) ||
		(nTypeCode == WT_STATIC) ||
		(nTypeCode == WT_RADIOBUTTON) ||
		(nTypeCode == WT_CHECKBOX) ||
		(nTypeCode == WT_GROUPBOX) ||
		(nTypeCode == WT_3STATE) ||
		(nTypeCode == WT_TABCONTROL)) then
		MoveToWindow (hTemp)
;		SayInteger (hTemp)
;		SayString (GetWord ())
;		Delay (5)
		;strNull=""
		if (GetHotKey() != strNull) then
			SayInteger (hTemp)
			if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
				Say (hkmsgHotKeysAre, ot_help)	;"Hot keys are as follows:"
			EndIf
			;wn289=" use alt  "
			If (nTypeCode == WT_BUTTON) then
				Let strType = TypeButton
			ElIf (nTypeCode == WT_STATIC) then
				Let strType = TypeStatic
			ElIf (nTypeCode == WT_RADIOBUTTON) then
				Let strType = TypeRadioButton
			ElIf	(nTypeCode == WT_CHECKBOX) then
				Let strType = TypeCheckBox
			ElIf (nTypeCode == WT_GROUPBOX) then
				Let strType = TypeGroupBox
			ElIf (nTypeCode == WT_TABCONTROL) then
				Let strType = TypeTabControl
			EndIf
			Let strHelpPhrase = hkmsgForThe + strSpace + GetObjectName () + strSpace + strType + strSpace + hkmsgAltPlus + strSpace + GetHotKey ()
				Say (strHelpPhrase, ot_help)
				let FoundHotKey = 1
		EndIf
	EndIf ; condition for static text or button
	Let hTemp = GetNextWindow (hTemp)
EndWhile
RestoreCursor ()
If (FoundHotKey == 0) then
	If (DialogActive () || GetWindowClass (hFirstChild) == wcDialog) then ;only say this string if in a dialog
		;"unable to determine hot keys in this dialog"
		Say (hkmsgUnable, ot_help)
	EndIf
EndIf
EndFunction


Script HotKeyHelp ()
Var String rWinClass, String FirstChildClass
Let rWinClass = GetWindowClass (GetRealWindow (GetFocus()))
Let FirstChildClass = GetWindowClass (GetFirstChild (GetRealWindow (GetFocus())))
If (rWinClass == wcGLBSWizard && FirstChildClass == wcDialog) then
	HotKeyLoop ()
Else
	PerformScript HotKeyHelp()
EndIf
EndScript
